#include <bits/stdc++.h>
using namespace std;

const double INF = 1e18;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n), h(n);
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    vector<double> ans(n, INF);
    stack<int> st;

    auto relax = [&](int i, int j) {
        // 1) jarbol
        double d1 = hypot(x[j] - x[i], h[j] - h[i]);
        ans[i] = min(ans[i], d1);

        // 2) kanap
        long long dx = llabs(h[j] - h[i]);

        long long xp;
        if (x[j] > x[i])
            xp = x[j] - dx;
        else
            xp = x[j] + dx;

        if (min(x[i], x[j]) <= xp && xp <= max(x[i], x[j])) {
            ans[i] = min(ans[i], (double)llabs(xp - x[i]));
        }
    };

    // LEVO ? DESNO
    for (int i = 0; i < n; i++) {
        while (!st.empty() && h[st.top()] < h[i])
            st.pop();
        if (!st.empty())
            relax(i, st.top());
        st.push(i);
    }

    while (!st.empty()) st.pop();

    // DESNO ? LEVO
    for (int i = n - 1; i >= 0; i--) {
        while (!st.empty() && h[st.top()] < h[i])
            st.pop();
        if (!st.empty())
            relax(i, st.top());
        st.push(i);
    }

    for (int i = 0; i < n; i++) {
        if (ans[i] == INF) cout << -1 << "\n";
        else cout << (long long)ans[i] << "\n";
    }
}